/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.findbar.FindBarPlugin;
import com.aptana.editor.findbar.impl.FindBarDecorator;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

abstract class FindBarOption
extends SelectionAdapter
implements SelectionListener {
    public final String image;
    public final String imageDisabled;
    public final String initialText;
    public final String fieldName;
    public final WeakReference<FindBarDecorator> findBarDecorator;
    public final boolean initiallyEnabled;
    boolean createMenuItem = true;
    public final String preferencesKey;
    private int internalUpdate = 0;
    private IPropertyChangeListener fPropertyChangeListener;

    boolean isCheckable() {
        return this.preferencesKey != null;
    }

    public FindBarOption(String fieldName, String image, String imageDisabled, String initialText, FindBarDecorator findBarDecorator, boolean initiallyEnabled, String preferencesKey) {
        this.fieldName = fieldName;
        this.image = image;
        this.imageDisabled = imageDisabled;
        this.initialText = initialText;
        this.findBarDecorator = new WeakReference<FindBarDecorator>(findBarDecorator);
        this.initiallyEnabled = initiallyEnabled;
        this.preferencesKey = preferencesKey;
        if (preferencesKey != null) {
            IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
            preferenceStore.addPropertyChangeListener(this.getPropertyChangeListener());
        }
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ToolItem item;
                    if (FindBarOption.this.preferencesKey.equals(event.getProperty()) && (item = FindBarOption.this.getToolItemFromDecorator()) != null) {
                        boolean val = Boolean.parseBoolean(StringUtil.getStringValue((Object)event.getNewValue()));
                        if (!item.isDisposed() && val != item.getSelection()) {
                            FindBarOption.this.startInternalUpdate();
                            try {
                                item.setSelection(val);
                            }
                            finally {
                                FindBarOption.this.endInternalUpdate();
                            }
                        }
                    }
                }
            };
        }
        return this.fPropertyChangeListener;
    }

    private void endInternalUpdate() {
        --this.internalUpdate;
    }

    private void startInternalUpdate() {
        ++this.internalUpdate;
    }

    public FindBarOption(String fieldName, String image, String imageDisabled, String initialText, FindBarDecorator findBarDecorator, String preferencesKey) {
        this(fieldName, image, imageDisabled, initialText, findBarDecorator, true, preferencesKey);
    }

    private void execute() {
        FindBarDecorator dec = (FindBarDecorator)this.findBarDecorator.get();
        if (dec != null) {
            this.execute(dec);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.internalUpdate > 0) {
            return;
        }
        if (this.preferencesKey != null) {
            FindBarDecorator.findBarConfiguration.toggle(this.preferencesKey);
        }
        this.execute();
    }

    protected abstract void execute(FindBarDecorator var1);

    public MenuItem createMenuItem(Menu menu) {
        MenuItem item;
        if (!this.createMenuItem) {
            return null;
        }
        final ToolItem toolItem = this.getToolItemFromDecorator();
        if (this.isCheckable()) {
            item = new MenuItem(menu, 32);
            if (!StringUtil.isEmpty((String)this.preferencesKey)) {
                IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
                item.setSelection(preferenceStore.getBoolean(this.preferencesKey));
            } else {
                item.setSelection(toolItem.getSelection());
            }
        } else {
            item = new MenuItem(menu, 8);
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FindBarOption.this.isCheckable()) {
                    if (!StringUtil.isEmpty((String)FindBarOption.this.preferencesKey)) {
                        FindBarDecorator.findBarConfiguration.toggle(FindBarOption.this.preferencesKey);
                    } else {
                        toolItem.setSelection(!toolItem.getSelection());
                    }
                } else {
                    FindBarOption.this.execute();
                }
            }
        });
        item.setImage(FindBarPlugin.getImage(this.image));
        item.setText("  " + toolItem.getToolTipText());
        return item;
    }

    public ToolItem createToolItem(ToolBar optionsToolBar) {
        if (!this.canCreateItem()) {
            return null;
        }
        ToolItem item = this.isCheckable() ? new ToolItem(optionsToolBar, 32) : new ToolItem(optionsToolBar, 8);
        item.setImage(FindBarPlugin.getImage(this.image));
        if (this.imageDisabled != null) {
            item.setDisabledImage(FindBarPlugin.getImage(this.imageDisabled));
        }
        item.setToolTipText(this.initialText);
        if (this.preferencesKey != null) {
            IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
            item.setSelection(preferenceStore.getBoolean(this.preferencesKey));
        }
        item.addSelectionListener((SelectionListener)this);
        if (!this.initiallyEnabled) {
            item.setEnabled(false);
        }
        this.setToolItemInDecorator(item);
        return item;
    }

    private void setToolItemInDecorator(ToolItem value) {
        try {
            Field field = this.getField();
            FindBarDecorator dec = (FindBarDecorator)this.findBarDecorator.get();
            field.set(dec, value);
        }
        catch (Exception e) {
            FindBarPlugin.log(e);
            throw new RuntimeException(e);
        }
    }

    private ToolItem getToolItemFromDecorator() {
        try {
            Field field = this.getField();
            FindBarDecorator dec = (FindBarDecorator)this.findBarDecorator.get();
            return (ToolItem)field.get(dec);
        }
        catch (Exception e) {
            FindBarPlugin.log(e);
            throw new RuntimeException(e);
        }
    }

    private Field getField() {
        try {
            FindBarDecorator dec = (FindBarDecorator)this.findBarDecorator.get();
            return dec.getClass().getDeclaredField(this.fieldName);
        }
        catch (Exception e) {
            FindBarPlugin.log(e);
            throw new RuntimeException(e);
        }
    }

    protected boolean canCreateItem() {
        return true;
    }

    public void dispose() {
        if (this.fPropertyChangeListener != null) {
            IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
            preferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
    }
}

